#!/bin/bash

# ANDROID_NDK_HOME and ANDROID_SDK_HOME need to be set (possibly to ~/Android/Sdk/ndk/##.#.#######/ and ~/Android/Sdk respectively)

VERSION=v5.1.LTS

git clone --depth 1 --branch v5.1.LTS https://github.com/arthenica/ffmpeg-kit.git
cd ffmpeg-kit

./android.sh --enable-x264 --enable-libvpx --enable-gpl --disable-arm-v7a{,-neon} --disable-x86{,-64} --no-archive

cd ..

OUT_DIRECTORY=ffmpeg-android-$VERSION
mkdir $OUT_DIRECTORY
cp -r ffmpeg-kit/prebuilt/android-arm64/{ffmpeg,libvpx,x264}/* $OUT_DIRECTORY/
cp $0 $OUT_DIRECTORY
tar c $OUT_DIRECTORY | xz -T0 > $OUT_DIRECTORY.tar.xz

